/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CImpFactory.h,v 1.2 1999/09/17 04:20:44 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CImpFactory_h	// [
#define Included_CImpFactory_h

#include "pgpClassesConfig.h"

#include "CErrorState.h"
#include "SingletonMacros.h"

_PGP_BEGIN

// Macros

#define DECLARE_IMPHOST(hostclass)										\
	public:																\
				hostclass();											\
		virtual	~hostclass();											\
																		\
	protected:															\
		const hostclass##Imp *	Imp() const {return mImp;}				\
		hostclass##Imp *		Imp() {return mImp;}					\
																		\
	private:															\
		hostclass##Imp	*mImp;

#define DEFINE_IMPHOST(hostclass, name, factory)						\
	hostclass::hostclass()												\
	{																	\
		factory::Instance().New##name(mImp);							\
	}																	\
																		\
	hostclass::~hostclass()												\
	{																	\
		factory::Instance().Delete##name(mImp);							\
	}

#define DECLARE_IMP_NEWFUNCS(type, name)								\
	public:																\
		SMART_ERROR	New##name(type *& pObject) const;					\
		void		Delete##name(type *& pObject) const;

#define DECLARE_IMP_NEWFUNCS_PURE(type, name)							\
	public:																\
		virtual SMART_ERROR	New##name(type *& pObject) const = 0;		\
		virtual void		Delete##name(type *& pObject) const = 0;

#if PGP_EXCEPTIONS

#define DEFINE_IMP_NEWFUNCS(realtype, type, factory, name)				\
	void																\
	factory::New##name(type *& pObject) const							\
	{																	\
		pObject = new realtype;											\
	}																	\
																		\
	void 																\
	factory::Delete##name(type *& pObject) const						\
	{																	\
		pgpAssertAddrValid(pObject, type);								\
																		\
		delete pObject;													\
		pObject = NULL;													\
	}

#else	// !PGP_EXCEPTIONS

#define DEFINE_IMP_NEWFUNCS(realtype, type, factory, name)				\
	CComboError															\
	factory::New##name(type *& pObject) const							\
	{																	\
		CComboError	error;												\
																		\
		if (IsNull(pObject = new realtype))								\
			error.pgpErr = kPGPError_OutOfMemory;						\
																		\
		if (error.IsntError())											\
		{																\
			error = pObject->Status();									\
																		\
			if (error.IsError())										\
			{															\
				delete pObject;											\
				pObject = NULL;											\
			}															\
		}																\
																		\
		return error;													\
	}																	\
																		\
	void 																\
	factory::Delete##name(type *& pObject) const						\
	{																	\
		pgpAssertAddrValid(pObject, type);								\
																		\
		delete pObject;													\
		pObject = NULL;													\
	}

#endif	// PGP_EXCEPTIONS


// Class CImpFactory

class CImpFactory SMART_ERROR_INHERIT
{
	NOT_COPYABLE(CImpFactory)

public:
			CImpFactory() { }
	virtual	~CImpFactory() = 0 { }
};

_PGP_END

#endif	// Included_CImpFactory_h
